﻿//////////////////////////////////////////////
// SingletonClass.h
//
// Class template de Singleton  
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Class ------------------------------------

namespace nkCommon
{
	///
	/// Basic class for Singleton creation.
	/// Use by inheriting from the class.
	///
	template <class T> class SingletonClass
	{
		protected :

			// Current living instance
			inline static T* _instance = nullptr ;

			// Constructor
			SingletonClass () = default ;

			// Destructor
			virtual ~SingletonClass ()
			{
				// Our instance only can be deleted
				_instance = nullptr ;
			}

		public :			

			///
			/// \returns Current living instance.
			/// 
			/// \remark If instance is non existing, it will be created on the spot.
			/// 
			static T* getInstance ()
			{
				if (!_instance)
					_instance = new T () ;

				return _instance ;
			}

			///
			/// \returns Current living instance.
			/// 
			/// \remark If instance is non existing, it will be created on the spot.
			/// 
			static T& getInstanceRef ()
			{
				if (!_instance)
					_instance = new T () ;

				return *_instance ;
			}

			///
			/// \returns Current living instance, if any. nullptr otherwise.
			///
			static T* getInstanceIfExisting ()
			{
				return _instance ;
			}

			///
			/// Deletes living instance.
			/// 
			static void kill ()
			{
				T* instanceCopy = _instance ;
				_instance = nullptr;
					
				delete instanceCopy ;
			}
	} ;
}